import QtQuick 2.12
import "../MedComponents"

Item {
    id: root
    anchors.fill: parent
    signal requestNew()
    signal requestSettings()
    signal requestRemove(int row)
    signal requestView(int row)
    ListView {
        anchors.top: parent.top
        anchors.bottom: btnNew.top
        anchors.left: parent.left
        anchors.right: parent.right
        model: dataModel
        delegate: ListDelegate {
            height: root.height * 0.1
            onRequestRemove: {
                confirmDialog.text = "Remove " + dataModel.roleFromRow(row, "lastName") + ',' + dataModel.roleFromRow(row, "firstName") + "?"
                confirmDialog.visible = true
                confirmDialog.index = row
            }
            onRequestView: root.requestView(row)
        }
        spacing: 2
    }

    Button {
        id: btnSettings
        anchors.bottom: parent.bottom
        anchors.right: parent.right
        height: parent.height * 0.1
        text: "⚙"
        onClicked: root.requestSettings()
    }

    Button {
        id: btnNew
        anchors.bottom: parent.bottom
        anchors.left: parent.left
        anchors.right: btnSettings.left
        height: parent.height * 0.1
        text: "Add Patient"
        onClicked: root.requestNew()
    }

    QuestionDialog {
           id: confirmDialog
           property int index: -1
           title: "Delete Record ?"
           visible: false
           onAccepted: root.requestRemove(index)
           onRejected: confirmDialog.visible = false
       }

}
